package ru.yandex.autotests.direct.web.steps.representatives.agency;

import java.util.List;

import org.hamcrest.Matcher;

import ru.yandex.autotests.direct.web.pages.representatives.agency.ManageClientsOfAgencyPage;
import ru.yandex.autotests.direct.web.steps.AlertSteps;
import ru.yandex.autotests.direct.web.util.DirectWebError;
import ru.yandex.autotests.irt.testutils.allure.AllureUtils;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.webdriver.steps.BaseSteps;

public class ManageClientsOfAgencyPageSteps extends BaseSteps {


    public ManageClientsOfAgencyPage onManageClientsOfAgency() {
        return ManageClientsOfAgencyPage.getInstance(ManageClientsOfAgencyPage.class, config);
    }

    @Step("Выбираем представителя {0}")
    public void selectRepresentative(String representativeLogin) {
        onManageClientsOfAgency().selectRepresentative(representativeLogin);
    }

    @Step("Устанавливаем фильтры: свободные клиенты = {0}, клиенты выбранного представителя = {1}," +
            " клиенты других представителей = {2}")
    public void setFilters(
            Boolean unassignedClients, Boolean clientsOfThisRepresentative, Boolean clientsOfOtherRepresentative) {
        onManageClientsOfAgency().setUnassignedClientsCheckBox(true);
        onManageClientsOfAgency().setClientsOfThisRepresentativeCheckBox(true);
        onManageClientsOfAgency().setClientsOfOtherRepresentativesCheckBox(true);

        onManageClientsOfAgency().setUnassignedClientsCheckBox(unassignedClients);
        onManageClientsOfAgency().setClientsOfThisRepresentativeCheckBox(clientsOfThisRepresentative);
        onManageClientsOfAgency().setClientsOfOtherRepresentativesCheckBox(clientsOfOtherRepresentative);
    }

    private void clickOnSaveButtonAndOKIfAlertPresents() {
        onManageClientsOfAgency().clickOnSaveButton();
        try {
            Thread.sleep(3000);
            AlertSteps alertSteps = AlertSteps.getInstance(AlertSteps.class, config);
            alertSteps.acceptIfPresent();
        }
        catch (Exception e) {
            throw new DirectWebError("проблема при попытке сохранить клиентов представителям");
        }
    }

    @Step("Очищаем выбор для всех свободных клиентов представителя {0}")
    public void clearAllAssignedClients(String representativeUid) {
        onManageClientsOfAgency().selectRepresentative(representativeUid);
        onManageClientsOfAgency().setUnassignedClientsCheckBox(Boolean.TRUE);
        onManageClientsOfAgency().setClientsOfThisRepresentativeCheckBox(Boolean.TRUE);
        onManageClientsOfAgency().setClientsOfOtherRepresentativesCheckBox(Boolean.TRUE);
        onManageClientsOfAgency().deselectAllVisibleClients();
        clickOnSaveButtonAndOKIfAlertPresents();
    }

    @Step("Устанавливаем чекбокс клиенту {0} представителя {1} в состояние {2}")
    public void reassignClientToRepresentative(String representativeUid, String clientLogin, Boolean assignment) {
        onManageClientsOfAgency().selectRepresentative(representativeUid);
        onManageClientsOfAgency().setUnassignedClientsCheckBox(Boolean.TRUE);
        onManageClientsOfAgency().setClientsOfThisRepresentativeCheckBox(Boolean.TRUE);
        onManageClientsOfAgency().setClientsOfOtherRepresentativesCheckBox(Boolean.TRUE);
        onManageClientsOfAgency().setAssignClientCheckBox(clientLogin, assignment);
        clickOnSaveButtonAndOKIfAlertPresents();
    }

    @Step("Нажимаем 'Сохранить выбор'")
    public void saveAssign() {
        clickOnSaveButtonAndOKIfAlertPresents();
    }

    @Step("Устанавливаем чекбокс клиенту {0} в состояние {1}")
    public void setAssignmentClient(String clientLogin, Boolean state) {
        onManageClientsOfAgency().setAssignClientCheckBox(clientLogin, state);
    }

    @Step("Проверяем, что количество назначенных клиентов удовлетворяет условию {0}")
    public void shouldSeeAssignedClientsCount(Matcher matcher) {
        onManageClientsOfAgency().checkAssignedClientsCount(matcher);
    }

    @Step("Проверяем, что чекбокс назначения клиента {0} удовлетворяет условию {1}")
    public void shouldSeeClientAssignment(String clientLogin, Matcher matcher) {
        onManageClientsOfAgency().shouldSeeClientAssignment(clientLogin, matcher);
    }

    @Step("Открываем представителей агентства")
    public void openAgencyRepresentatives() {
        onManageClientsOfAgency().clickOnAgencyRepresentativesLink();
    }

    @Step("Проверяем список клиентов")
    public void shouldSeeClientLogins(Matcher<List<String>> matcher) {
        AllureUtils.addTextAttachment("Ожидаемый список логинов клиентов", matcher.toString());
        onManageClientsOfAgency().checkClientsListLogins(matcher);

    }
}
