package ru.yandex.autotests.direct.web.steps.representatives.agency;

import java.util.List;

import org.hamcrest.Matcher;

import ru.yandex.autotests.direct.utils.beans.IBeanWrapper;
import ru.yandex.autotests.direct.web.objects.AccountWeb;
import ru.yandex.autotests.direct.web.pages.representatives.agency.DeleteAgRepPage;
import ru.yandex.autotests.direct.web.pages.representatives.agency.ShowAgRepsPage;
import ru.yandex.autotests.direct.web.steps.AlertSteps;
import ru.yandex.autotests.irt.testutils.allure.AllureUtils;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.webdriver.steps.BaseSteps;

import static org.hamcrest.MatcherAssert.assertThat;
import static ru.yandex.autotests.direct.utils.beans.BeanWrapper.wrap;
import static ru.yandex.autotests.direct.web.util.beanutils.BeanHelper.getOnlyFields;
import static ru.yandex.qatools.allure.webdriver.pages.BasePageObject.withParameters;
import static ru.yandex.qatools.htmlelements.matchers.WebElementMatchers.exists;

/**
 * @author Alex-samo (alex-samo@yandex-team.ru)
 *         Date: 08.10.13
 */
public class ShowAgRepsPageSteps extends BaseSteps {

    public ShowAgRepsPage onShowAgReps() {
        return ShowAgRepsPage.getInstance(ShowAgRepsPage.class, config);
    }

    public DeleteAgRepPage onDeleteAgRep() {
        return DeleteAgRepPage.getInstance(DeleteAgRepPage.class, config);
    }

    @Step("Открываем активных представителей")
    public void openActiveRepresentatives() {
        onShowAgReps().clickOnActiveRepresentativesLink();
    }

    @Step("Открываем удаленных представителей")
    public void openDeletedRepresentatives() {
        onShowAgReps().clickOnDeletedRepresentativesLink();
    }

    @Step("Кликаем 'Добавить нового представителя'")
    public void addNewRepresentative() {
        onShowAgReps().addNewRepresentativeLinkClick();
    }

    @Step("Открываем страницу изменеия главного представителя")
    public void openChangeSeniorRepresentativePage() {
        onShowAgReps().clickOnChangeSeniorRepresentativeLink();
    }

    @Step("Проверяем параметры главного представителя")
    public void shouldSeeSeniorRepresentativeFields(IBeanWrapper<AccountWeb> accountWeb, String... fields) {
        AccountWeb expectedAccountWeb = getOnlyFields(accountWeb.getBean(), fields);
        AllureUtils.addJsonAttachment("Ожидаемые параметры аккаунта", expectedAccountWeb.toString());
        onShowAgReps().shouldSeeSeniorRepresentative(expectedAccountWeb);
    }

    @Step("Проверяем значения представителя агенства")
    public void shouldSeeAdministratorRepresentativeFields(IBeanWrapper<AccountWeb> accountWeb) {
        AllureUtils.addJsonAttachment("Ожидаемые параметры аккаунта", accountWeb.toString());
        onShowAgReps().shouldSeeAdministratorRepresentative(accountWeb.getBean());
    }

    @Step("Проверяем значения представителя по работе с клиентами")
    public void shouldSeeWorkWithClientsRepresentativeFields(IBeanWrapper<AccountWeb> accountWeb) {
        AllureUtils.addJsonAttachment("Ожидаемые параметры аккаунта", accountWeb.toString());
        onShowAgReps().shouldSeeWorkWithClientsRepresentative(accountWeb.getBean());
    }

    public void shouldSeeWorkWithClientsRepresentativeFields(IBeanWrapper<AccountWeb> accountWeb, String... fields) {
        AccountWeb expectedAccountWeb = getOnlyFields(accountWeb.getBean(), fields);
        shouldSeeWorkWithClientsRepresentativeFields(wrap(expectedAccountWeb));
    }

    public void shouldSeeAdministratorRepresentativeFields(IBeanWrapper<AccountWeb> accountWeb, String... fields) {
        AccountWeb expectedAccountWeb = getOnlyFields(accountWeb.getBean(), fields);
        shouldSeeAdministratorRepresentativeFields(wrap(expectedAccountWeb));
    }

    @Step("Проверяем список представителей агентства")
    public void shouldSeeAdministratorRepresentativeLogins(Matcher matcher) {
        AllureUtils.addTextAttachment("Ожидаемый список логинов", matcher.toString());
        assertThat(onShowAgReps().getAllAdministratorRepresentativeLogins(), matcher);
    }

    @Step("Проверяем список представителей по работе с клиентами")
    public void shouldSeeWorkWithClientsRepresentativeLogins(Matcher matcher) {
        AllureUtils.addTextAttachment("Ожидаемый список логинов", matcher.toString());
        assertThat(onShowAgReps().getAllWorkWithClientsRepresentativeLogins(), matcher);
    }

    @Step("Проверяем удаленного представителя")
    public void shouldSeeDeletedRepresentativeFields(IBeanWrapper<AccountWeb> accountWeb, String... fields) {
        AccountWeb expectedAccountWeb = getOnlyFields(accountWeb.getBean(), fields);
        AllureUtils.addJsonAttachment("Ожидаемые параметры аккаунта", expectedAccountWeb.toString());
        onShowAgReps().shouldSeeDeletedRepresentative(expectedAccountWeb);
    }

    @Step("Открываем страницу редактирования представителя агентства {0}")
    public void openEditAdministratorRepresentativePage(String login) {
        onShowAgReps().editAdministratorRepresentative(login);
    }

    @Step("Открываем страницу редактирования представителя по работе с клиентами {0}")
    public void openEditWorkWithClientsRepresentativePage(String login) {
        onShowAgReps().editWorkWithClientsRepresentative(login);
    }

    @Step("Восстанавливаем представителя {0}")
    public void restoreRepresentative(String login) {
        onShowAgReps().restoreRepresentative(login);
    }

    @Step("Удаляем представителя по работе с клиентами {0} и проверяем, что алерт удовлетворяет условию {1}")
    public void deleteWorkWithClientsRepresentativeWithConfirmDelete(String login, Matcher<String> matcher) {
        onShowAgReps().deleteWorkWithClientsRepresentative(login);
        AlertSteps.getInstance(AlertSteps.class, config).accept(matcher);
    }

    @Step("Удаляем представителя агентства {0} и проверяем, что алерт удовлетворяет условию {1}")
    public void deleteAdministratorRepresentativeWithConfirmDelete(String login, Matcher<String> matcher) {
        onShowAgReps().deleteAdministratorRepresentative(login);
        AlertSteps.getInstance(AlertSteps.class, config).accept(matcher);
    }

    @Step("Открываем страницу назначения клиентов")
    public void openAssignClients() {
        onShowAgReps().clickOnAssignClientsLink();
    }

    @Step("Открываем клиентов представителя по работе с клиентами {0}")
    public void openWorkWithClientsRepresentativeClients(String representativeLogin) {
        onShowAgReps().clickOnWorkWithClientsRepresentativeLogin(representativeLogin);
    }

    @Step("Удаляем всех представителей по работе с клиентами")
    public void deleteAllWorkWithClientsRepresentatives() {
        if (onShowAgReps().isWorkWithClientsRepresentativeTable(exists())) {
            List<String> representativesLoginList =
                    onShowAgReps().getAllWorkWithClientsRepresentativeLogins();
            for (String login : representativesLoginList) {
                onDeleteAgRep().open("delete.agency.representative", withParameters(login));
                onDeleteAgRep().clickOnSubmitButton();
            }
        }
    }

    @Step("Удаляем всех представителей агентства")
    public void deleteAllAdministratorRepresentatives() {
        if (onShowAgReps().isAdministratorRepresentativeTable(exists())) {
            List<String> representativesLoginList = onShowAgReps().getAllAdministratorRepresentativeLogins();
            for (String login : representativesLoginList) {
                onDeleteAgRep().open("delete.agency.representative", withParameters(login));
                onDeleteAgRep().clickOnSubmitButton();
            }
        }
    }

    @Step("Получение логина главного представителя")
    public String getSeniorRepresentativeLogin() {
        return onShowAgReps().getSeniorRepresentativeLogin();
    }
}
