package ru.yandex.autotests.direct.web.steps.representatives.agency;

import org.hamcrest.Matcher;

import ru.yandex.autotests.direct.web.pages.representatives.agency.SwitchAgChiefPage;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.webdriver.steps.AlertSteps;
import ru.yandex.qatools.allure.webdriver.steps.BaseSteps;

/**
 * @author Alex-samo (alex-samo@yandex-team.ru)
 *         Date: 18.10.13
 */
public class SwitchAgChiefPageSteps extends BaseSteps {

    SwitchAgChiefPage onSwitchAgChief() {
        return SwitchAgChiefPage.getInstance(SwitchAgChiefPage.class, config);
    }

    @Step("Выбираем нового главного представителя {0} и проверяем, что алерт удовлетворяет условию {1}")
    public void selectNewSeniorRepresentativeAndCheckForAlert(String login, Matcher<String> matcher) {
        onSwitchAgChief().selectNewSeniorRepresentative(login);
        onSwitchAgChief().clickOnSetButton();
        AlertSteps.getInstance(AlertSteps.class, config).accept(matcher);
    }
}
