package ru.yandex.autotests.direct.web.steps.representatives.client;

import ru.yandex.autotests.direct.utils.beans.IBeanWrapper;
import ru.yandex.autotests.direct.web.objects.AccountWeb;
import ru.yandex.autotests.direct.web.pages.representatives.client.AddClRepPage;
import ru.yandex.autotests.irt.testutils.allure.AllureUtils;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.webdriver.steps.BaseSteps;

/**
 * @autor Alex-samo (alex-samo@yandex-team.ru)
 * Date: 04.10.13
 */
public class AddClRepPageSteps extends BaseSteps {


    public AddClRepPage onAddClRep() {
        return AddClRepPage.getInstance(AddClRepPage.class, config);
    }

    @Step("Заполняем параметры представителя")
    public void fillRepresentativePersonalData(IBeanWrapper<AccountWeb> accountWeb) {
        AllureUtils.addJsonAttachment("Параметры аккаунта", accountWeb.toString());
        onAddClRep().fillRepresentativePersonalData(accountWeb.getBean());
    }

    @Step("Нажимаем 'Зарегистрировать представителя'")
    public void registerRepresentative() {
        onAddClRep().clickOnRegisterButton();
    }

    @Step("Нажимаем 'Подтвердить'")
    public void submit() {
        onAddClRep().clickOnSubmitButton();
    }
}
