package ru.yandex.autotests.direct.web.steps.representatives.client;

import org.hamcrest.Matcher;

import ru.yandex.autotests.direct.utils.beans.IBeanWrapper;
import ru.yandex.autotests.direct.web.objects.AccountWeb;
import ru.yandex.autotests.direct.web.pages.representatives.client.DeleteClRepPage;
import ru.yandex.autotests.direct.web.pages.representatives.client.ShowClRepsPage;
import ru.yandex.autotests.irt.testutils.allure.AllureUtils;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.webdriver.steps.BaseSteps;

import static org.hamcrest.MatcherAssert.assertThat;
import static ru.yandex.qatools.allure.webdriver.pages.BasePageObject.withParameters;
import static ru.yandex.qatools.htmlelements.matchers.WebElementMatchers.exists;

/**
 * Created with IntelliJ IDEA.
 * User: alex-samo
 * Date: 03.10.13
 */
public class ShowClRepsPageSteps extends BaseSteps {

    public ShowClRepsPage onShowClReps() {
        return ShowClRepsPage.getInstance(ShowClRepsPage.class, config);
    }

    public DeleteClRepPage onDeleteClRep() {
        return DeleteClRepPage.getInstance(DeleteClRepPage.class, config);
    }

    @Step("Открываем активных представителей")
    public void openActiveRepresentatives() {
        onShowClReps().clickOnActiveRepresentativesLink();
    }

    @Step("Открываем удаленных представителей")
    public void openDeletedRepresentatives() {
        onShowClReps().clickOnDeletedRepresentativesLink();
    }

    @Step("Добавляем нового представителя")
    public void addNewRepresentative() {
        onShowClReps().addNewRepresentativeLinkClick();
    }

    @Step("Проверяем параметры представителя")
    public void shouldSeeRepresentative(IBeanWrapper<AccountWeb> representativeAccountWeb) {
        AllureUtils.addJsonAttachment("Параметры аккаунта", representativeAccountWeb.toString());
        onShowClReps().shouldSeeRepresentative(representativeAccountWeb.getBean());
    }

    @Step("Открываем страницу редактирования представителя")
    public void openEditRepresentativePage(String login) {
        onShowClReps().editRepresentative(login);
    }

    @Step("Меняем главного представителя")
    public void changeSeniorRepresentative() {
        onShowClReps().changeSeniorRepresentative();
    }

    @Step("Проверяем, что логины представителей удовлетворяют условию {0}")
    public void shouldSeeRepresentativeLogins(Matcher matcher) {
        assertThat(onShowClReps().getAllRepresentativeLogins(), matcher);
    }

    @Step("Проверяем удаленных представителей")
    public void shouldSeeDeletedRepresentative(IBeanWrapper<AccountWeb> accountWeb) {
        accountWeb.getBean().setPhone(null);
        AllureUtils.addJsonAttachment("Параметры проверяемого аккаунта", accountWeb.toString());
        onShowClReps().shouldSeeDeletedRepresentative(accountWeb.getBean());
    }

    @Step("Восстанавливаем представителя {0}")
    public void restoreRepresentative(String login) {
        onShowClReps().restoreRepresentative(login);

    }

    @Step("Удаляем представителя {0} и проверяем, что алерт удовлетворяет условию {1}")
    public void deleteRepresentativeWithConfirmDelete(String login, Matcher<String> matcher) {
        onShowClReps().deleteRepresentative(login);
        onShowClReps().acceptAlert(matcher);
    }

    @Step("Удаляем всех представителей")
    public void deleteAllRepresentatives() {
        if (onShowClReps().isRepresentativeTable(exists())) {
            for (String login : onShowClReps().getAllRepresentativeLogins()) {
                onDeleteClRep().open("delete.representative", withParameters(login));
                onDeleteClRep().clickOnSubmitButton();
            }
        }
    }

    @Step("Получаем логин главного представителя")
    public String getSeniorRepresentativeLogin() {
        return onShowClReps().getSeniorRepresentativeLogin();
    }
}
