package ru.yandex.autotests.direct.web.steps.representatives.client;

import org.hamcrest.Matcher;

import ru.yandex.autotests.direct.web.pages.representatives.client.SwitchClChiefPage;
import ru.yandex.autotests.direct.web.steps.AlertSteps;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.webdriver.steps.BaseSteps;

/**
 * @author Alex-samo (alex-samo@yandex-team.ru)
 *         Date: 20.10.13
 */
public class SwitchClChiefPageSteps extends BaseSteps {

    SwitchClChiefPage onSwitchClChief() {
        return SwitchClChiefPage.getInstance(SwitchClChiefPage.class, config);
    }

    @Step("Выбираем нового главного представителя {0} и проверяем, что алерт удовлетворяет условию {1}")
    public void selectNewSeniorRepresentativeAndCheckForAlert(String login, Matcher<String> matcher) {
        onSwitchClChief().selectNewSeniorRepresentative(login);
        onSwitchClChief().clickOnSetButton();
        AlertSteps.getInstance(AlertSteps.class, config).accept(matcher);
    }
}
