package ru.yandex.autotests.direct.web.steps.smartbanners;

import ru.yandex.autotests.direct.web.pages.smartbanners.ShowCreativesPage;
import ru.yandex.autotests.direct.web.pages.smartbanners.blocks.CreativesViewModeEnum;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.webdriver.steps.BaseSteps;

public class SmartBannersPageSteps extends BaseSteps {

    private ShowCreativesPage onShowCreativesPage() {
        return ShowCreativesPage.getInstance(ShowCreativesPage.class, config);
    }

    @Step("Открываем попап подробнее о причинах отклонения на модерации")
    public void openInfoAboutRejectionPopup(Long bannerId) {
        onShowCreativesPage().openInfoAboutRejectionPopup(bannerId);
    }

    @Step("Выбор вида просмотра списка креативов на странице")
    public void selectCreativesViewMode(CreativesViewModeEnum mode) {
        onShowCreativesPage().selectViewMode(mode);
    }
}
