package ru.yandex.autotests.direct.web.steps.statistic;

import org.apache.http.NameValuePair;
import ru.yandex.autotests.direct.utils.beans.IBeanWrapper;
import ru.yandex.autotests.direct.web.data.statistic.NewReportInfoWeb;
import ru.yandex.autotests.direct.web.data.statistic.StatisticType;
import ru.yandex.autotests.direct.web.pages.statistic.ShowCampStatPageBEM;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.webdriver.steps.BaseSteps;

import java.util.List;

import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.core.IsCollectionContaining.hasItem;
import static ru.yandex.autotests.direct.web.util.OperationSystemUtils.sleep;


/**
 * @author Roman Kuhta (kuhtich@yandex-team.ru)
 */
public class ShowCampStatPageBEMSteps extends BaseSteps {

    private List<NameValuePair> actualParameters;

    public ShowCampStatPageBEM onShowCampStatPage() {
        return ShowCampStatPageBEM.getInstance(ShowCampStatPageBEM.class, config);
    }

    @Step
    public void selectStatisticType(StatisticType type) {
        onShowCampStatPage().clickTab(type);
    }

    @Step
    public void showStatisticFor(IBeanWrapper<NewReportInfoWeb> info) {
        onShowCampStatPage().fillStatisticRequestInfo(info.getBean());
        onShowCampStatPage().clickShow();
        sleep(2000);
    }

    @Step
    public void actualURLParameters(List<NameValuePair> actualParameters) {
        this.actualParameters = actualParameters;
    }

    @Step
    public void checkParameter(NameValuePair pair) {
        assertThat("неверный параметр", actualParameters, hasItem(pair));
    }

    @Step
    public void openImagePopup(Long bannerId) {
        onShowCampStatPage().openImagePopup(bannerId);
    }

    @Step("Открываем попап превью баннера {0}")
    public void openBannerPreviewPopup(Long bannerId) {
        onShowCampStatPage().clickOnStatisticsWizardBannerLink(bannerId);
    }
}
