package ru.yandex.autotests.direct.web.steps.statistic;

import java.util.List;
import java.util.function.Predicate;

import org.apache.http.NameValuePair;
import org.hamcrest.Matcher;
import org.openqa.selenium.WebElement;

import ru.yandex.autotests.direct.utils.beans.IBeanWrapper;
import ru.yandex.autotests.direct.web.data.statistic.NewReportInfoWeb;
import ru.yandex.autotests.direct.web.data.statistic.StatisticType;
import ru.yandex.autotests.direct.web.objects.banners.BannerPhraseInfoWeb;
import ru.yandex.autotests.direct.web.objects.statistic.StatisticMinusPhraseInfoWeb;
import ru.yandex.autotests.direct.web.pages.statistic.ShowCampStatPage;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.webdriver.steps.BaseSteps;
import ru.yandex.qatools.htmlelements.matchers.WebElementMatchers;

import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.not;
import static org.hamcrest.core.IsCollectionContaining.hasItem;
import static ru.yandex.autotests.direct.web.steps.CommonSteps.waitForElement;
import static ru.yandex.autotests.direct.web.util.OperationSystemUtils.sleep;


/**
 * @author Roman Kuhta (kuhtich@yandex-team.ru)
 */
public class ShowCampStatPageSteps extends BaseSteps {

    private List<NameValuePair> actualParameters;

    public ShowCampStatPage onShowCampStatPage() {
        return ShowCampStatPage.getInstance(ShowCampStatPage.class, config);
    }

    @Step
    public void selectStatisticType(StatisticType type) {
        onShowCampStatPage().clickTab(type);
    }

    @Step
    public void selectAllCamaignsStatisticType(StatisticType type) {
        onShowCampStatPage().clickAllCampaignsTab(type);
    }

    @Step
    public void showStatisticFor(IBeanWrapper<NewReportInfoWeb> info) {
        onShowCampStatPage().fillStatisticRequestInfo(info.getBean());
        onShowCampStatPage().clickShow();
        sleep(2000);
    }

    @Step
    public void actualURLParameters(List<NameValuePair> actualParameters) {
        this.actualParameters = actualParameters;
    }

    @Step
    public void checkParameter(NameValuePair pair) {
        assertThat("неверный параметр", actualParameters, hasItem(pair));
    }

    @Step
    public void showPlot() {
        onShowCampStatPage().clickOnShowPlotButton();
    }

    @Step("Проверяем, что попап графика по статистике соответствует условию {0}")
    public void shouldSeeChartStatisticsBlock(Matcher<WebElement> matcher) {
        onShowCampStatPage().checkChartStatisticsBlock(matcher);
    }

    @Step("Открываем попап превью баннера {0}")
    public void openBannerPreviewPopup(Long bannerId) {
        onShowCampStatPage().clickOnStatisticsWizardBannerLink(bannerId);
    }

    @Step("Открываем попап с картинкой из попапа прьвью банера {0}")
    public void openImagePopupFromBannerPreviewPopup(Long bannerId) {
        openBannerPreviewPopup(bannerId);
        onShowCampStatPage().openImagePopupOnStatisticsWizardTab();
    }

    @Step("Получаем список фраз по поисковым запросам")
    public List<BannerPhraseInfoWeb> getRowFromSearchQueries() {
        return onShowCampStatPage().getRowFromSearchQueries();
    }

    @Step("Проставляем чекбоксы для фраз")
    public void setCheckboxForPhrase(Predicate<BannerPhraseInfoWeb> predicate, Boolean state) {
        onShowCampStatPage().setCheckboxForPhrase(predicate, state);
    }

    @Step("Проставляем чекбокс для всех Поисковых запросов")
    public void setCheckBoxForAllSearchQueries() {
        onShowCampStatPage().setCheckBoxForAllSearchQueries(true);
    }

    @Step("Открываем попап добавления фраз")
    public void clickAddPlusPhraseButton() {
        onShowCampStatPage().clickAddPlusPhraseButton();
    }

    @Step("Изменяем текст и/или ставку")
    public void fillPhraseParameters(List<BannerPhraseInfoWeb> phraseInfoList) {
        onShowCampStatPage().fillPhraseParameters(phraseInfoList);
    }

    @Step("Открываем попап добавления минус фраз")
    public void clickAddMinusPhraseButton() {
        onShowCampStatPage().clickAddMinusPhraseButton();
    }

    @Step("Изменяем текст и выставляем цель группа/кампания")
    public void fillMinusPhraseParameters(List<StatisticMinusPhraseInfoWeb> statisticMinusPhraseInfoWebList) {
        onShowCampStatPage().fillMinusPhraseParameters(statisticMinusPhraseInfoWebList);
    }

    @Step("Изменяем текст и выставляем цель группа/кампания")
    public void fillMinusPhraseParametersAndExpectSuccess(
            List<StatisticMinusPhraseInfoWeb> statisticMinusPhraseInfoWebList)
    {
        onShowCampStatPage().fillMinusPhraseParameters(statisticMinusPhraseInfoWebList);
        waitForElement(onShowCampStatPage().onAddMinusPhrasePopup().getWrappedElement(), 5,
                not(WebElementMatchers.isDisplayed()));
    }
}
