package ru.yandex.autotests.direct.web.steps.statistic;

import java.util.List;

import org.apache.http.NameValuePair;

import ru.yandex.autotests.direct.utils.beans.IBeanWrapper;
import ru.yandex.autotests.direct.web.data.statistic.NewReportInfoWeb;
import ru.yandex.autotests.direct.web.pages.statistic.StatisticsReportWizardPageBEM;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.webdriver.steps.BaseSteps;
import ru.yandex.qatools.htmlelements.matchers.WebElementMatchers;

import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.not;
import static org.hamcrest.core.IsCollectionContaining.hasItem;
import static ru.yandex.autotests.direct.web.steps.CommonSteps.waitForElement;
import static ru.yandex.autotests.direct.web.util.OperationSystemUtils.sleep;


/**
 * @author Roman Kuhta (kuhtich@yandex-team.ru)
 */
public class StatisticsReportWizardSteps extends BaseSteps {

    private List<NameValuePair> actualParameters;

    public StatisticsReportWizardPageBEM onReportWizardStatPage() {
        return StatisticsReportWizardPageBEM.getInstance(StatisticsReportWizardPageBEM.class, config);
    }

    @Step
    public void showStatisticFor(IBeanWrapper<NewReportInfoWeb> info) {
        onReportWizardStatPage().fillStatisticRequestInfo(info.getBean());
        takeScreenshot();
        onReportWizardStatPage().clickShow();
        sleep(2000);
    }

    @Step
    public void actualURLParameters(List<NameValuePair> actualParameters) {
        this.actualParameters = actualParameters;
    }

    @Step
    public void checkParameter(NameValuePair pair) {
        assertThat("неверный параметр", actualParameters, hasItem(pair));
    }

    @Step
    public void openBannerPreviewPopup(Long bannerId) {
        onReportWizardStatPage().clickOnBannerPreviewLink(bannerId);
    }

    @Step("Кликаем по кнопке 'Показать график' и ждем загрузки графика")
    public void clickOnChartSwitcherAndWaitForChart() {
        onReportWizardStatPage().clickOnChartSwitcher();
        onReportWizardStatPage().onStatisticChart().waitForChartLoading();
    }
}
