package ru.yandex.autotests.direct.web.steps.transfer;

import org.hamcrest.Matcher;
import org.openqa.selenium.internal.WrapsElement;

import ru.yandex.autotests.direct.web.pages.transfer.TransferStepZeroPage;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.webdriver.pages.BasePageObject;
import ru.yandex.qatools.allure.webdriver.steps.BaseSteps;

import static org.hamcrest.MatcherAssert.assertThat;

/**
 * User: buhter
 * Date: 25.02.13
 * Time: 18:08
 * Степы выбора клиентов для переноса средств для роли Агентство
 */
public class TransferStepZeroSteps extends BaseSteps {

    private TransferStepZeroPage onTransferStepZeroPage() {
        return BasePageObject.getInstance(TransferStepZeroPage.class, config);
    }

    @Step("Выбираем клиента от которого будут переносится средства")
    public void selectTransferClientFrom(String clientName) {
        if (!clientName.equals("")) {
            onTransferStepZeroPage().onSelectTransferClientForm.selectClientFrom.selectClient(clientName);
        }
    }

    @Step("Выбираем клиента к которому будут переносится средства")
    public void selectTransferClientTo(String clientName) {
        if (!clientName.equals("")) {
            onTransferStepZeroPage().onSelectTransferClientForm.selectClientTo.selectClient(clientName);
        }
    }

    @Step("Отправляем форму выбора клиентов для переноса средств")
    public void submit() {
        onTransferStepZeroPage().onSelectTransferClientForm.submit();
    }

    @Step("Проверяем кнопку отправки формы выбора клиентов для переноса средств")
    public void shouldSeeSubmitButton(Matcher<WrapsElement> matcher) {
        assertThat("кнопка сабмита не прошла проверку",
                onTransferStepZeroPage().onSelectTransferClientForm.submitButton, matcher);
    }
}