package ru.yandex.autotests.direct.web.util;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

import ru.yandex.autotests.direct.utils.config.DirectTestRunProperties;

public class DateHelper {

    private static final String DATE_FORMAT = "yyyy-MM-dd";

    private static Locale currentLocale = new Locale(DirectTestRunProperties.getInstance().getDirectCmdLocale());
    private static DateFormat formatter;

    private static DateFormat getFormatter() {
        if (formatter == null) {
            formatter = new SimpleDateFormat(DATE_FORMAT, currentLocale);
        }
        return formatter;
    }

    public static Calendar getCalendar() {
        return Calendar.getInstance(currentLocale);
    }

    public static Date parseDate(String date) {
        try {
            return getFormatter().parse(date);
        } catch (ParseException ex) {
            throw new IllegalArgumentException("Не удалось распарсить строку с датой '" + date + "': " + ex.getMessage());
        }
    }


    public static String reverseDateString(String dateString) {
        String reverseDate = "";

        try {
            String[] list = dateString.split("\\.");
            reverseDate += list[2];
            reverseDate += "." + list[1];
            reverseDate += "." + list[0];
        } catch (IndexOutOfBoundsException ex) {
            throw new IllegalArgumentException("Строка даты '" + dateString + "' имеет неправильный формат:" + ex.getMessage());
        }

        return reverseDate;
    }

    public static Date getDefaultDate() {
        Calendar cal = getCalendar();
        cal.set(1995, 0, 1, 0, 0, 0);
        return cal.getTime();
    }
}
