package ru.yandex.autotests.direct.web.util;

import java.util.concurrent.TimeUnit;

import org.hamcrest.Matcher;

import ru.yandex.autotests.direct.utils.config.DirectTestRunProperties;

import static ru.yandex.qatools.htmlelements.matchers.MatcherDecorators.should;
import static ru.yandex.qatools.htmlelements.matchers.MatcherDecorators.timeoutHasExpired;

/**
 * User: xy6er
 * Date: 19.04.13
 * Time: 19:27
 */

public abstract class DirectWaiters {

    public static <T> Matcher<T> coreWaiter(Matcher<T> matcher) {
        return coreWaiter(matcher, (int) DirectTestRunProperties.getInstance().getDirectWebWebdriverImplicityWaitTimeoutSec());
    }

    public static <T> Matcher<T> coreWaiter(Matcher<T> matcher, int timeoutIntSecond) {
        return should(matcher).whileWaitingUntil(timeoutHasExpired(TimeUnit.SECONDS.toMillis(timeoutIntSecond)));
    }
}