package ru.yandex.autotests.direct.web.util;

import ru.yandex.autotests.direct.utils.config.DirectTestRunProperties;

import java.util.HashMap;
import java.util.Map;

/**
 * Утилитный класс создающий обертку над сущностью, позволяет указывать различные варианты данных, которые зависят от
 * среды выполнения. Создает Проксирующий объект, который в рантайме будет обращаться к верному для данной среды объекту
 *
 * @param <T> тип объекта для которого создается обертка
 *            <br>
 *            Пример использования: <br>
 *            <pre>{@code
 *                        List<Long> someIds = new EnvironmentWrapper<List<Long>>()
 *                                                     .withEntity(TS, of(1L, 2L, 3L))
 *                                                     .withEntity(DEVTEST, of(4L, 5L, 6L))
 *                                                     .getEntity();
 *                       }</pre>
 */
public class EnvironmentWrapper<T> {
    Map<Environment, T> beans = new HashMap<>();

    public enum Environment {
        TS,
        DEVTEST
    }

    public EnvironmentWrapper() {
    }

    public EnvironmentWrapper<T> withEntity(Environment environment, T entity) {
        beans.put(environment, entity);
        return this;
    }

    public T getEntity() {
        if (beans.isEmpty()) {
            throw new RuntimeException("Необходимо задать сущность хотя бы для одной из сред");
        }
        T obj;
        if (DirectTestRunProperties.getInstance().getDirectHost().contains("test-direct")) {
            obj = beans.get(Environment.TS);
        } else {
            obj = beans.get(Environment.DEVTEST);
        }
        return obj;
    }
}
