package ru.yandex.autotests.direct.web.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

import org.apache.commons.io.IOUtils;

/**
 * @author : Alex Samokhin (alex-samo@yandex-team.ru)
 *         Date: 05.08.14
 */
public class FileHelper {

    public static File streamToFile(InputStream in, String fileName) {

        final File tempFile = new File(fileName);
        if (!tempFile.exists()) {
            try {
                tempFile.createNewFile();
            } catch (IOException e) {
                throw new DirectWebError("ошибка создания файла " + fileName);
            }
        }
        tempFile.deleteOnExit();
        try {
            FileOutputStream out = new FileOutputStream(tempFile);
            IOUtils.copy(in, out);
        } catch (IOException e) {
            throw new DirectWebError("ошибка копирования потока в файл " + fileName);
        }

        return tempFile;
    }

    public static boolean deleteFile(String fileName) {
        boolean result = true;
        File file = new File(fileName);
        if (file.exists()) {
            result = file.delete();
        }
        return result;
    }
}
