package ru.yandex.autotests.direct.web.util;

/**
 * @author : Alex Samokhin (alex-samo@yandex-team.ru)
 *         Date: 29.04.14
 */
public class OperationSystemUtils {

    public static boolean isWindows() {

        String os = System.getProperty("os.name").toLowerCase();
        //windows
        return (os.contains("win"));

    }

    public static boolean isMac() {

        String os = System.getProperty("os.name").toLowerCase();
        //Mac
        return (os.contains("mac"));

    }

    public static boolean isUnix() {

        String os = System.getProperty("os.name").toLowerCase();
        //linux or unix
        return (os.contains("nix") || os.contains("nux"));

    }

    public static String getOSVerion() {
        return System.getProperty("os.version");
    }

    public static void sleep(long timeoutInMills) {
        try {
            Thread.sleep(timeoutInMills);
        } catch (InterruptedException e) {
            throw new DirectWebError("Exception while sleep", e);
        }
    }
}
