package ru.yandex.autotests.direct.web.util;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringHelper {

    public static boolean equalsIgnoreDiffWhitespaces(String a, String b) {
        return withSimpleWhitespaces(a).equals(withSimpleWhitespaces(b));
    }

    /**
     * Change  non-breaking space to space with code 32
     *
     * @param src
     * @return string with simple spaces
     */
    public static String withSimpleWhitespaces(String src) {
        return src.replaceAll("\u00a0", " ");
    }

    public static List<Long> getNumericDataFromText(String text) {

        Pattern pattern = Pattern.compile("\\d+");
        Matcher matcher = pattern.matcher(text);
        List<Long> returnList = new ArrayList<>();
        while (matcher.find()) {
            returnList.add(Long.valueOf(matcher.group()));
        }
        return returnList;
    }

    public static Double getNumericValueWithoutSpacesAndWords(String text) {
        return Double.parseDouble(text.replaceAll("\\s\\D*",""));
    }
}
