package ru.yandex.autotests.direct.web.util;

import java.net.URI;

import com.google.common.net.InternetDomainName;

public class URLHelper {
    public static String getTopLevelDomain(String url) {
        return toInternetDomain(url).publicSuffix().toString();
    }

    public static String getTopPrivateDomain(String url) {
        return toInternetDomain(url).topPrivateDomain().toString();
    }

    private static InternetDomainName toInternetDomain(String url) {
        return InternetDomainName.from(URI.create(url).getHost());
    }
}
