package ru.yandex.autotests.direct.web.util;

import java.util.Set;

import org.hamcrest.Matcher;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.remote.LocalFileDetector;
import org.openqa.selenium.remote.RemoteWebDriver;
import ru.yandex.autotests.direct.web.pages.statistic.WebElementVisibilityState;

/**
 * @author Roman Kuhta (kuhtich@yandex-team.ru)
 */
public class WebDriverUtils {

    public static boolean activatePage(WebDriver driver, Matcher<WebDriver> matcher) {
        Set windowHandles = driver.getWindowHandles();
        for (Object windowHandle : windowHandles.toArray()) {
            driver.switchTo().window((String) windowHandle);
            if (matcher.matches(driver)) {
                return true;
            }
        }
        return false;
    }

    public static void setLocaleFileDetector(WebDriver driver) {
        if (driver instanceof RemoteWebDriver) {
            ((RemoteWebDriver) driver).setFileDetector(new LocalFileDetector());
        }
    }

    public static void hideElement(WebDriver driver, WebElement element) {
        setElementVisibility(driver, element, WebElementVisibilityState.HIDDEN);
    }

    public static void setElementVisibility(WebDriver driver, WebElement element, WebElementVisibilityState state) {
        ((JavascriptExecutor)driver).executeScript("arguments[0].style.visibility='" + state.toString() + "'", element);
    }
}
