package ru.yandex.autotests.direct.web.util;

import java.util.concurrent.TimeUnit;

import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

import ru.yandex.autotests.direct.cmd.DirectCmdSteps;
import ru.yandex.autotests.direct.cmd.rules.NeedsCmdSteps;
import ru.yandex.autotests.direct.web.TestEnvironment;
import ru.yandex.autotests.direct.web.util.rules.ExceptionWrapperRule;
import ru.yandex.autotests.httpclient.lite.core.exceptions.BackEndClientException;
import ru.yandex.autotests.httpclientlite.HttpClientLiteException;
import ru.yandex.qatools.allure.webdriver.rules.RetryRule;
import ru.yandex.terra.junit.rules.BottleMessageRule;

public class WebRuleFactory {
    private static Integer DEFAULT_RETRY_TIMES = 2;
    private static Integer DEFAULT_RETRY_TIMEOUT = 5;

    private static RetryRule retryOnError() {
        return RetryRule
                .retry()
                .times(DEFAULT_RETRY_TIMES)
                .every(DEFAULT_RETRY_TIMEOUT, TimeUnit.SECONDS)
                .ifException(HttpClientLiteException.class)
                .ifException(BackEndClientException.class);
    }

    public static RuleChain retryOnErrorChain(TestRule... rules) {
        RuleChain chain = RuleChain.outerRule(retryOnError());
        chain = chain.around(new ExceptionWrapperRule());
        for (TestRule rule : rules) {
            chain = chain.around(rule);
        }

        return chain;
    }

    public static RuleChain defaultClassRuleChain(TestRule... rules) {
        TestRule semaphoreRule = TestEnvironment.getSemaphore();
        RuleChain chain = RuleChain.emptyRuleChain();
        if (semaphoreRule != null) {
            chain = chain.around(semaphoreRule);
        }
        chain = chain.around(customRuleChain(rules));
        return chain;
    }

    public static RuleChain defaultRuleChain(TestRule... rules) {
        RuleChain chain = RuleChain.emptyRuleChain();/*.outerRule(Timeout.seconds(getDirectWebProperties().getPageLoadTimeout() * 10));*/
        chain = chain.around(new BottleMessageRule())
                .around(new ExceptionWrapperRule())
                .around(customRuleChain(rules));
        return chain;
    }

    public static RuleChain customRuleChain(TestRule... rules) {
        return customRuleChain(new DirectCmdSteps(), rules);
    }

    public static RuleChain customRuleChain(DirectCmdSteps directCmdSteps, TestRule... rules) {
        RuleChain chain = RuleChain.emptyRuleChain();
        for (TestRule rule : rules) {
            if (rule instanceof NeedsCmdSteps) {
                ((NeedsCmdSteps) rule).withDirectCmdSteps(directCmdSteps);
            }
            chain = chain.around(rule);
        }
        return chain;
    }
}
