package ru.yandex.autotests.direct.web.util.beanutils;

/**
 * @author Roman Kuhta (kuhtich@yandex-team.ru)
 */

import java.lang.reflect.InvocationTargetException;

import org.apache.commons.beanutils.BeanUtilsBean;

import ru.yandex.autotests.direct.web.util.DirectWebError;

public class NullAwareBeanUtilsBean extends BeanUtilsBean {
    @Override
    public void copyProperty(Object dest, String name, Object value)
            throws IllegalAccessException, InvocationTargetException {
        if (value == null) return;
        super.copyProperty(dest, name, value);
    }

    @Override
    public void copyProperties(Object dest, Object orig) {
        try {
            super.copyProperties(dest, orig);
        } catch (Exception e) {
            throw new DirectWebError(e);
        }
    }
}