package ru.yandex.autotests.direct.web.util.check;

import java.util.Date;
import java.util.HashSet;
import java.util.Set;

import org.openqa.selenium.logging.LogEntries;
import org.openqa.selenium.logging.LogEntry;
import org.openqa.selenium.logging.LogType;

import ru.yandex.autotests.direct.web.util.DirectWebError;
import ru.yandex.qatools.allure.webdriver.rules.WebDriverConfiguration;

public class CheckConsoleError {
    public void checkJSErrorOnThePage(WebDriverConfiguration driverConfiguration) {
        Set<String> errorStrings = new HashSet<>();
        errorStrings.add("SyntaxError");
        errorStrings.add("EvalError");
        errorStrings.add("ReferenceError");
        errorStrings.add("RangeError");
        errorStrings.add("TypeError");
        errorStrings.add("URIError");
        LogEntries logEntries = driverConfiguration.getDriver().manage().logs().get(LogType.BROWSER);
        for (LogEntry logEntry : logEntries) {
            for (String errorString : errorStrings) {
                if (logEntry.getMessage().contains(errorString)) {
                    throw new DirectWebError("Ошибка в консоли");
                }
            }
        }
    }
}
