package ru.yandex.autotests.direct.web.util.converters;

import ru.yandex.autotests.direct.web.objects.banners.BannerPhraseInfoWeb;
import ru.yandex.autotests.direct.web.objects.retargeting.RetargetingConditionWeb;

/**
 * @author Roman Kuhta (kuhtich@yandex-team.ru)
 */
public class Banners {

    /**
     * Converts campaign web bean to api bean
     *
     * @param condition
     * @return CampaignInfo without extended properties for web
     */
    public static BannerPhraseInfoWeb toBannerInfo(RetargetingConditionWeb condition) {
        BannerPhraseInfoWeb result = new BannerPhraseInfoWeb();
        if (condition.getBannerId() != null) {
            result.setBannerId(condition.getBannerId());
        }
        result.setPhrase(condition.getRetargetingConditionName());
        if (condition.getContextPrice() != null) {
            result.setContextPrice(Float.valueOf(condition.getContextPrice()));
        }
        if (condition.getAdGroupId() != null) {
            result.setAdGroupID(Long.valueOf(condition.getAdGroupId()));
        }
        if (condition.getIsActive() != null) {
            result.setActive(condition.getIsActive());
        }
        return result;
    }
}
