package ru.yandex.autotests.direct.web.util.converters;

import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;

import static java.util.stream.Collectors.toList;
import static org.codehaus.groovy.runtime.InvokerHelper.asList;

public class ListConverter {

    public static <T> List<String> toListOfStrings(T... items) {
        return toListOfStrings(asList(items));
    }

    public static <T> List<String> toListOfStrings(List<T> items) {
        return items == null ? null :
                items.stream().map(Objects::toString).collect(toList());
    }

    public static <T> String[] toArrayOfStrings(T... items) {
        return items == null ? null :
                Stream.of(items).map(Objects::toString).toArray(String[]::new);
    }
}