package ru.yandex.autotests.direct.web.util.converters;

import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang3.ArrayUtils;
import ru.yandex.autotests.direct.web.objects.banners.BannerInfoWeb;
import ru.yandex.autotests.direct.web.objects.banners.commons.SiteLinkInfoWeb;
import ru.yandex.autotests.direct.web.util.DirectWebError;
import ru.yandex.autotests.directapi.common.api45mng.ContactInfo;
import ru.yandex.autotests.directapi.common.api45mng.MediaplanAd;
import ru.yandex.autotests.directapi.common.api45mng.Sitelink;

/**
 * User: alexey-n
 * Date: 09.09.13
 * Time: 13:09
 */
public class MediaplanAdConverter {

    public static MediaplanAd toMediaplanAd(BannerInfoWeb bannerInfo) {
        MediaplanAd mediaplanAd = new MediaplanAd();
        mediaplanAd.setDomain(bannerInfo.getDomain());
        mediaplanAd.setGeo(bannerInfo.getGeo());
        mediaplanAd.setHref(bannerInfo.getHref());
        mediaplanAd.setMinusKeywords(bannerInfo.getMinusKeywords());
        mediaplanAd.setText(bannerInfo.getText());
        mediaplanAd.setTitle(bannerInfo.getTitle());
        mediaplanAd.setTitle2(bannerInfo.getTitleExtension());
        try {
            if (bannerInfo.getContactInfo() != null) {
                ContactInfo contactInfo = new ContactInfo();
                BeanUtils.copyProperties(contactInfo, bannerInfo.getContactInfo());
                mediaplanAd.setContactInfo(contactInfo);
            }
            if (bannerInfo.getSitelinks() != null) {
                Sitelink[] sitelinks = null;
                for (SiteLinkInfoWeb sitelink : bannerInfo.getSitelinks()) {
                    Sitelink newSitelink = new Sitelink();
                    BeanUtils.copyProperties(newSitelink, sitelink);
                    sitelinks = ArrayUtils.add(sitelinks, newSitelink);
                }
                mediaplanAd.setSitelinks(sitelinks);
            }

        } catch (ReflectiveOperationException e) {
            throw new DirectWebError("Can't copy bannerInfo to MediaplanAd");
        }
        return mediaplanAd;
    }
}
