package ru.yandex.autotests.direct.web.util.converters;

import ru.yandex.autotests.direct.utils.money.Money;
import ru.yandex.autotests.direct.web.data.priceconstructor.MediaplanTrafficVolume;
import ru.yandex.autotests.direct.web.objects.banners.BannerPhraseInfoWeb;
import ru.yandex.autotests.direct.web.objects.banners.OptimizedPhraseInfoWeb;
import ru.yandex.autotests.direct.web.util.beanutils.BeanHelper;
import ru.yandex.autotests.direct.web.util.helpers.campaigns.BannersHelper;

import java.math.RoundingMode;

public class Phrases {

    public static OptimizedPhraseInfoWeb toOptimizedPhraseInfoWeb(BannerPhraseInfoWeb bannerPhraseInfo) {
        OptimizedPhraseInfoWeb optimizedPhraseInfoWeb = new OptimizedPhraseInfoWeb();
        String[] fields = new String[]{ "phrase"};
        BeanHelper.copyProperties(optimizedPhraseInfoWeb, BannersHelper.getPhraseFields(bannerPhraseInfo, fields));
        optimizedPhraseInfoWeb.setTrafficVolume(MediaplanTrafficVolume.HUNDRED);
        return optimizedPhraseInfoWeb;
    }
}
