package ru.yandex.autotests.direct.web.util.converters;


import ru.yandex.autotests.direct.web.data.timetarget.TimeTargetItem;

/**
 * @author Roman Kuhta (kuhtich@yandex-team.ru)
 */
public class TimeTarget {
    /**
     * Converts TimeTargetItem array of api bean to Integer [][]
     *
     * @param timeTargetItems
     * @return If timeTargetItems does not contain coefficient for some days or hours
     * corresponding value in return matrix will be null
     */
    public static Integer[][] toMatrix(TimeTargetItem[] timeTargetItems) {
        Integer[][] result = new Integer[7][24];
        for (TimeTargetItem item : timeTargetItems) {
            for (int day = 1; day <= item.getDays().length; day++) {
                for (int hour = 0; hour < item.getHours().length; hour++) {
                    result[item.getDays()[day - 1] - 1][item.getHours()[hour]] = item.getBidCoefs()[hour];
                }
            }
        }
        return result;
    }
}
