package ru.yandex.autotests.direct.web.util.converters;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import org.apache.commons.lang3.tuple.ImmutablePair;
import org.openqa.selenium.WebElement;

import ru.yandex.autotests.direct.web.pages.campaigns.timetarget.elements.CoefficientScaleItem;
import ru.yandex.autotests.direct.web.pages.campaigns.timetarget.elements.DaySquareBEM;
import ru.yandex.autotests.direct.web.pages.campaigns.timetarget.elements.TimeTargetTableCheckBox;

/**
 * @author Roman Kuhta (kuhtich@yandex-team.ru)
 */
public class TimeTargetConverter {

    /**
     * Converts list of days web elements to HashMap
     *
     * @param webElements collection of days
     * @return Map key is an ImmutablePair of day and hour
     */
    public static HashMap<ImmutablePair<Integer, Integer>, DaySquareBEM> toDaySquaresMap(List<WebElement> webElements) {
        HashMap<ImmutablePair<Integer, Integer>, DaySquareBEM> daySquares = new HashMap<>();
        for (WebElement element : webElements) {
            DaySquareBEM ds = new DaySquareBEM(element);
            daySquares.put(ImmutablePair.of(ds.getDay(), ds.getHour()), ds);
        }
        return daySquares;
    }

    /**
     * Converts list of checkboxes web elements to HashMap
     *
     * @param checkBoxes list of checkboxes
     * @return list of TimeTargetTableCheckBoxes
     */
    public static ArrayList<TimeTargetTableCheckBox> toTimeTargetCheckBoxesList(List<WebElement> checkBoxes) {
        ArrayList<TimeTargetTableCheckBox> timeTargetTableCheckBoxes = new ArrayList<>();
        for (WebElement element : checkBoxes) {
            timeTargetTableCheckBoxes.add(new TimeTargetTableCheckBox(element));
        }
        return timeTargetTableCheckBoxes;
    }

    /**
     * Converts list of coefficient scale web elements to HashMap
     *
     * @param coefficientScaleItemsWeb collection of coefficient scale web elements
     * @return Map key is a value of coefficient item
     */
    public static HashMap<Integer, CoefficientScaleItem> toCoefficientScaleItemsMap(List<WebElement> coefficientScaleItemsWeb) {
        HashMap<Integer, CoefficientScaleItem> coefficientScaleItems = new HashMap<>();
        for (WebElement element : coefficientScaleItemsWeb) {
            CoefficientScaleItem si = new CoefficientScaleItem(element);
            coefficientScaleItems.put(si.getCoefficient(), si);
        }
        return coefficientScaleItems;
    }
}
