package ru.yandex.autotests.direct.web.util.helpers;

import java.util.List;
import java.util.NoSuchElementException;

import org.openqa.selenium.Cookie;

import ru.yandex.autotests.direct.web.steps.UserSteps;

public class CookieHelper {
    /**
     * change cookie yandexuid to cookie with constant value, because from this cookie depends Spros page, so
     * for same screenshots we need to have same value
     * Issue: https://st.yandex-team.ru/DIRECT-62269#1489137275000
     * @param user
     */
    public static void setConstantYandexUIDCookie(UserSteps user) {
        final String UID = "115";
        final String YANDEX_UID = "yandexuid";

        List<Cookie> cookies = user.getUserCookies();
        Cookie oldYandexUidCookie = cookies.stream()
                .filter(x -> x.getName().equals(YANDEX_UID))
                .findFirst()
                .orElseThrow(NoSuchElementException::new);

        Cookie newYandexUidCookie = new Cookie.Builder(oldYandexUidCookie.getName(), UID)
                .domain(oldYandexUidCookie.getDomain())
                .expiresOn(oldYandexUidCookie.getExpiry())
                .isHttpOnly(oldYandexUidCookie.isHttpOnly())
                .isSecure(oldYandexUidCookie.isSecure())
                .path(oldYandexUidCookie.getPath())
                .build();

        for(int i = 0; i < cookies.size(); i++) {
            if(cookies.get(i).getName().equals(YANDEX_UID)) {
                cookies.set(i, newYandexUidCookie);
            }
        }
        user.setCustomCookies(cookies);
    }
}
