package ru.yandex.autotests.direct.web.util.helpers;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

import ru.yandex.autotests.direct.utils.config.DirectTestRunProperties;
import ru.yandex.autotests.direct.web.util.DirectWebError;

public class DateParser {

    private static final String DATE_FORMAT = "dd MMM yyyy";

    private static Locale currentLocale = new Locale(DirectTestRunProperties.getInstance().getDirectCmdLocale());
    private static DateFormat formatter;

    private static DateFormat getFormatter() {
        if (formatter == null) {
            formatter = new SimpleDateFormat(DATE_FORMAT, currentLocale);
        }
        return formatter;
    }

    private static DateFormat getFormatter(String dateFormat) {
        return new SimpleDateFormat(dateFormat, currentLocale);
    }

    public static Calendar parseDate(String dateString, String format) {
        Date date;
        try {
            date = getFormatter(format).parse(dateString);
        } catch (ParseException ex) {
            throw new DirectWebError("Не удалось распарсить строку с датой '" + dateString + "': " + ex.getMessage());
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal;
    }
}
