package ru.yandex.autotests.direct.web.util.helpers;

import java.text.DecimalFormat;

import ru.yandex.autotests.direct.utils.config.DirectTestRunProperties;
import ru.yandex.autotests.direct.utils.money.Money;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.direct.utils.money.MoneyFormat;
import ru.yandex.autotests.direct.utils.strategy.objects.StrategyInfoWeb;
import ru.yandex.autotests.direct.utils.textresource.TextResourceFormatter;
import ru.yandex.autotests.direct.web.data.textresources.DayBudgetResource;

import static ru.yandex.autotests.direct.utils.textresource.TextResources.getText;

/**
 * @author : Alex Samokhin (alex-samo@yandex-team.ru)
 *         Date: 08.04.14
 */
public class DayBudgetResourceHelper {

    public static String getShowMode(StrategyInfoWeb.ShowMode showMode) {
        DayBudgetResource dayBudgetResource = DayBudgetResource.SHOW_MODE_STANDART;
        switch (showMode) {
            case DEFAULT:
                dayBudgetResource = DayBudgetResource.SHOW_MODE_STANDART;
                break;
            case STRETCHED:
                dayBudgetResource = DayBudgetResource.SHOW_MODE_STRECHED;
                break;
        }
        return getText(dayBudgetResource, DirectTestRunProperties.getInstance().getDirectCmdLocale());
    }

    public static String getNameText() {
        return getText(DayBudgetResource.DAY_BUDGET, DirectTestRunProperties.getInstance().getDirectCmdLocale());
    }

    public static String getInfoText(Money amount, StrategyInfoWeb.ShowMode showMode, String locale) {
        TextResourceFormatter resourceFormatter = TextResourceFormatter.resource(DayBudgetResource.DAY_BUDGET_INFO).args
                (amount.stringValue(MoneyFormat.TWO_DIGITS_POINT_SEPARATED),
                        getCurrencyAbbreviation(MoneyCurrency.get(amount.getCurrency()), locale), getShowMode(showMode));
        return resourceFormatter.toString();
    }

    public static String getHelpInfoText(MoneyCurrency moneyCurrency, String locale) {
        TextResourceFormatter resourceFormatter = TextResourceFormatter.resource(DayBudgetResource.CONTAINS_HELP_INFO).
                args(new DecimalFormat("#").format(moneyCurrency.getMinDayBudgetAmount()),
                        getCurrencyAbbreviation(moneyCurrency, locale));
        return resourceFormatter.toString();
    }

    public static String getMinPriceErrorText(MoneyCurrency moneyCurrency, String locale) {
        TextResourceFormatter resourceFormatter = TextResourceFormatter.resource(DayBudgetResource.MIN_PRICE_ERROR).
                args(moneyCurrency.getMinDayBudgetAmount().stringValue(MoneyFormat.TWO_DIGITS_POINT_SEPARATED),
                        getCurrencyAbbreviation(moneyCurrency, locale));
        return resourceFormatter.toString();
    }

    public static String getTreeTimesLimitText() {
        return getText(DayBudgetResource.TREE_TIMES_LIMIT, DirectTestRunProperties.getInstance().getDirectCmdLocale());
    }

    public static String getDayBudgetBalanceText(Money dayBudgetSpent, String locale) {
        TextResourceFormatter resourceFormatter = TextResourceFormatter.resource(
                DayBudgetResource.BALANCE_OF_DAY_BUDGET).
                args(dayBudgetSpent.stringValue(MoneyFormat.TWO_DIGITS_POINT_SEPARATED) + " " +
                        MoneyCurrency.get(dayBudgetSpent.getCurrency()).getAbbreviation(locale));
        return resourceFormatter.toString();
    }

    public static String getViewStoppedAfterDayBudgetSpentText() {
        return getText(DayBudgetResource.VIEW_STOPPED_AFTER_DAY_BUDGET_SPENT, DirectTestRunProperties.getInstance().getDirectCmdLocale());
    }

    public static String getCurrencyAbbreviation(MoneyCurrency moneyCurrency, String locale) {
        return moneyCurrency.getAbbreviation(locale);
    }
}
