package ru.yandex.autotests.direct.web.util.helpers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Класс служит для хранения в памяти структуры деревьев интерфейса, например древо регионов, интересов в соц. дем
 * Общий алгоритм работы с деревьями такого рода можно представить в виде:
 * 1. По data-bem строим в памяти модель древа
 * 2. с помощью метода getAncestorsFor получаем всех родителей искомого узла
 * 3. Раскрываем узлы в контексте предметной области
 */
public class TreeHelper {
    /**
     * <Ключ потомок, значение родитель>
     */
    private Map<String, String> treeMap;

    /**
     * Дерево
     *
     * 0 _
     * \  \
     *  \  1
     *   \  \
     *    \  2 - 3 - 4
     *     5
     *      \
     *       6 - 7 - 8
     *   Должно быть разложено в хеш вида:
     *   {
     *       "2": "1",
     *       "3": "1",
     *       "4": "1",
     *       "6": "5',
     *       "7": "5",
     *       "8": "5",
     *       "1": "0",
     *       "5": "0"
     *   }
     * @param treeMap
     */
    public TreeHelper(HashMap<String, String> treeMap) {
        this.treeMap = treeMap;
    }

    public List<String> getAncestorsFor(String childId) {
        List<String> result = new ArrayList<>();
        getAncestorsFor(childId, result);
        return result;
    }

    private void getAncestorsFor(String childId, List<String> parents) {
        if (!treeMap.containsKey(childId)) {
            return;
        }
        String parentId = treeMap.get(childId);
        getAncestorsFor(parentId, parents);
        parents.add(parentId);
    }
}
