package ru.yandex.autotests.direct.web.util.helpers.campaigns;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;

import ru.yandex.autotests.direct.web.objects.banners.BannerInfoWeb;
import ru.yandex.autotests.direct.web.objects.banners.BannerPhraseInfoWeb;
import ru.yandex.autotests.direct.web.objects.banners.commons.SiteLinkInfoWeb;
import ru.yandex.autotests.direct.web.steps.UserSteps;
import ru.yandex.autotests.direct.web.util.DirectWebError;

import static java.util.Objects.requireNonNull;
import static java.util.stream.Collectors.toList;
import static ru.yandex.autotests.direct.web.util.beanutils.BeanHelper.copyProperties;
import static ru.yandex.autotests.direct.web.util.beanutils.BeanHelper.getOnlyFields;

/**
 * @author Roman Kuhta (kuhtich@yandex-team.ru)
 */
public class BannersHelper {
    private static SiteLinkInfoWeb[] sourceSiteLinksArray = {
            new SiteLinkInfoWeb("контактик", "https://vk.com"),
            new SiteLinkInfoWeb("маркет", "https://market.yandex.ru"),
            new SiteLinkInfoWeb("одноклассники", "https://ok.ru"),
            new SiteLinkInfoWeb("фейсбук", "https://www.facebook.com")
    };

    public static <T extends BannerPhraseInfoWeb> T getPhraseFields(T phraseInfo, String... fields) {
        T BannerPhraseInfoWeb = getOnlyFields(phraseInfo, fields);
        BannerPhraseInfoWeb.setPhrase(phraseInfo.getPhrase());
        BannerPhraseInfoWeb.setBannerId(phraseInfo.getBannerId());
        BannerPhraseInfoWeb.setAdGroupID(phraseInfo.getAdGroupID());
        return BannerPhraseInfoWeb;
    }

    public static BannerPhraseInfoWeb[] toBannerPhrasesInfoWeb(BannerPhraseInfoWeb[] phrases) {
        if (phrases == null) {
            return null;
        }
        List<BannerPhraseInfoWeb> webPhrases = toBannerPhrasesInfoWebList(phrases);
        return webPhrases.toArray(new BannerPhraseInfoWeb[webPhrases.size()]);
    }

    public static List<BannerPhraseInfoWeb> toBannerPhrasesInfoWebList(BannerPhraseInfoWeb[] phrases) {
        requireNonNull(phrases);
        return Stream.of(phrases)
                .map(x -> {
                    BannerPhraseInfoWeb bannerPhraseInfoWeb = new BannerPhraseInfoWeb();
                    copyProperties(bannerPhraseInfoWeb, x);
                    return bannerPhraseInfoWeb;
                })
                .collect(toList());
    }

    public static Long[] createBannersGroup(UserSteps user, BannerInfoWeb banner, BannerInfoWeb[] banners) {
        for (int i = 0; i < banners.length; i++) {
            if (banners[i] == null) {
                banners[i] = new BannerInfoWeb();
            }
            copyProperties(banners[i], banner);
        }
        return user.byUsingBackend()
                .addBannersToGroup(0L, banner.getCampaignId(), banners)
                .stream()
                .map(x -> x.getBannerId())
                .toArray(Long[]::new);
    }

    public static SiteLinkInfoWeb[] getSiteLinksArrayByCount(Integer siteLinksCount) {

        if ((siteLinksCount > sourceSiteLinksArray.length) || (siteLinksCount <= 0)) {
            throw new DirectWebError(
                    "Количество быстрых ссылок может быть от 1 до " + sourceSiteLinksArray.length + "!");
        }
        SiteLinkInfoWeb[] siteLinkInfoWebArray = new SiteLinkInfoWeb[siteLinksCount];
        for (int i = 0; i < siteLinksCount; i++) {
            siteLinkInfoWebArray[i] = sourceSiteLinksArray[i];
        }
        return siteLinkInfoWebArray;
    }
}