package ru.yandex.autotests.direct.web.util.helpers.campaigns;

import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.FeedsUpdateStatus;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.CampaignsRecord;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.FeedsRecord;
import ru.yandex.autotests.direct.web.TestEnvironment;
import ru.yandex.autotests.directapi.model.User;

import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.lessThanOrEqualTo;
import static org.hamcrest.Matchers.not;
import static ru.yandex.autotests.direct.httpclient.util.CommonUtils.sleep;
import static ru.yandex.autotests.direct.web.TestEnvironment.getNewHttpClientSteps;
import static ru.yandex.autotests.direct.web.TestEnvironment.newDbSteps;

/**
 * Created by aleran on 07.12.2015.
 */
public class PerformanceCampaignHelper {

    public static void waitForFeedLoad(String clientId, String feedId) {
        final int ATTEMPTS = 40;
        final int TIMEOUT = 2_000;
        int currentAttempt = ATTEMPTS;
        int shardId = newDbSteps().shardingSteps().getShardByClientID(Long.parseLong(clientId));
        TestEnvironment.getApiUserSteps().getDarkSideSteps().getRunScriptSteps()
                .runPpcFeedToBannerLand(shardId, clientId);
        while (currentAttempt > 0) {
            FeedsRecord feedsRecord = newDbSteps().useShard(shardId).feedsSteps().getFeed(Long.parseLong(feedId));
            if (feedsRecord.getUpdateStatus().equals("New")) {
                sleep(TIMEOUT);
            } else {
                break;
            }
            currentAttempt--;
        }
        assertThat("исчерпано кол-во попыток ожидания обновления фида", currentAttempt, not(lessThanOrEqualTo(0)));
    }

    public static void deleteCreative(Long creativeId) {
        if (creativeId != null) {
            newDbSteps().bannersPerformanceSteps().deleteBannersPerformanceRecord(creativeId);
            newDbSteps().perfCreativesSteps().deletePerfCreatives(creativeId);
        }
    }

    public static void deleteFeed(Long feedId, String ulogin) {
        if (feedId != null) {
            newDbSteps().feedsSteps().deleteAdgroupsPerformanceRecords(feedId);
            newDbSteps().feedsSteps()
                    .updateFeedsStatus(FeedsUpdateStatus.Done, User.get(ulogin).getClientID(), feedId);
            getNewHttpClientSteps().ajaxDeleteFeedsSteps().deleteFeed(ulogin, feedId);
        }
    }
}
