package ru.yandex.autotests.direct.web.util.helpers.campaigns;

import org.apache.commons.lang3.tuple.Pair;

import ru.yandex.autotests.direct.web.data.textresources.TimeTargetTestStrings;

import static org.apache.commons.lang3.text.WordUtils.capitalize;

/**
 * @author Roman Kuhta (kuhtich@yandex-team.ru)
 */
public class TimeTargetHelper {

    public static String formatHour(int hour) {
        return String.format(TimeTargetTestStrings.FORMAT_HOLIDAYS_SELECT_HOUR.toString(), hour);
    }

    public static String formatHourSummary(int hour) {
        return String.format(TimeTargetTestStrings.FORMAT_HOLIDAYS_SUMMARY_HOUR.toString(), hour);
    }

    public static String formatPercent(int percent) {
        return String.format(TimeTargetTestStrings.FORMAT_HOLIDAYS_SELECT_PERCENT.toString(), percent);
    }

    public static String formatPeriods(String dayName, Pair<Integer, Integer>... periods) {
        String res = capitalize(dayName) + ".: ";
        for (int i = 0; i < periods.length; i++) {
            res += formatHourSummary(periods[i].getLeft()) + "-" + formatHourSummary(periods[i].getRight());
            if (i < periods.length - 1)
                res += ", ";
        }
        return res;
    }

    public static String formatPeriods(String fromDay, String toDay, Pair<Integer, Integer>... periods) {
        String periodName = capitalize(fromDay) + ".-" + capitalize(toDay);
        return formatPeriods(periodName, periods);
    }

}
