package ru.yandex.autotests.direct.web.util.helpers.urlparameter;

import java.util.List;

import static java.util.stream.Collectors.joining;

public class ListMapper implements ParameterMapper {
    private String nullString = "null";
    private String delimiter = ",";

    @Override
    public String map(Object o) {
        String result = null;
        if (o != null) {
            List<?> values = (List) o;
            result = values.stream()
                    .map(x -> x == null ? nullString : x.toString())
                    .collect(joining(delimiter));
        }
        return result;
    }

    public ListMapper withNullString(String nullString) {
        this.nullString = nullString;
        return this;
    }

    public ListMapper withDelimiter(String delimiter) {
        this.delimiter = delimiter;
        return this;
    }
}