package ru.yandex.autotests.direct.web.util.helpers.urlparameter;

import java.lang.reflect.Field;
import java.util.List;
import java.util.stream.Collectors;

import org.apache.commons.lang3.reflect.FieldUtils;

import ru.yandex.autotests.httpclientlite.core.request.utils.keyvalue.annotations.SerializeKey;

public class UrlParameterMapper {
    private ParameterMapper listMapper = new ListMapper();
    private String paramSeparator = "&";
    private String paramValSeparator = "=";
    private boolean includeEmptyFields = false;

    public String mapToUrl(Object obj) {
        return FieldUtils.getAllFieldsList(obj.getClass()).stream()
                .filter(field -> field.isAnnotationPresent(SerializeKey.class) &&
                        (includeEmptyFields || readField(field, obj) != null))
                .map(field -> field.getAnnotation(SerializeKey.class).value() + paramValSeparator + fieldToStringMapper(
                        field, obj))
                .collect(Collectors.joining(paramSeparator));
    }

    private String fieldToStringMapper(Field field, Object obj) {
        String result = "";
        try {
            Object val = readField(field, obj);
            if (val == null) {
                return result;
            }
            if (field.isAnnotationPresent(CustomUrlMapper.class)) {
                Class<? extends ParameterMapper> mapperClass = field.getAnnotation(CustomUrlMapper.class).value();
                ParameterMapper parameterMapper = mapperClass.newInstance();
                result = parameterMapper.map(val);
            } else if (field.getType().isAssignableFrom(List.class)) {
                result = listMapper.map(val);
            } else {
                result = val.toString();
            }
        } catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    public UrlParameterMapper withListMapper(ParameterMapper listMapper) {
        this.listMapper = listMapper;
        return this;
    }

    public UrlParameterMapper withParamSeparator(String paramSeparator) {
        this.paramSeparator = paramSeparator;
        return this;
    }

    public UrlParameterMapper withParamValSeparator(String paramValSeparator) {
        this.paramValSeparator = paramValSeparator;
        return this;
    }

    public UrlParameterMapper withIncludeEmptyFields(boolean includeEmptyFields) {
        this.includeEmptyFields = includeEmptyFields;
        return this;
    }

    private Object readField(Field field, Object obj) {
        try {
            return FieldUtils.readField(field, obj, true);
        } catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }
}