package ru.yandex.autotests.direct.web.util.matchers;

import java.util.Collection;

import org.apache.commons.lang3.StringUtils;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

/**
 * User: alexey-n
 * Date: 30.08.13
 * Time: 11:15
 */
public class CollectionItemMatcher<T> extends TypeSafeMatcher<Collection<T>> {

    private Matcher<T> itemMatcher;

    public CollectionItemMatcher(Matcher<T> itemMatcher) {
        this.itemMatcher = itemMatcher;
    }

    @Override
    protected boolean matchesSafely(Collection<T> items) {
        for (T item : items) {
            if (!itemMatcher.matches(item)) {
                return false;
            }
        }
        return true;
    }

    @Override
    protected void describeMismatchSafely(Collection<T> items, Description mismatchDescription) {
        mismatchDescription.appendText("collection is:").appendValue(StringUtils.join(items, ","));
    }

    @Override
    public void describeTo(Description description) {
        description.appendText("all item of collection: ").appendDescriptionOf(itemMatcher);
    }

    @Factory
    public static CollectionItemMatcher allItemsOfCollection(Matcher itemMatcher) {
        return new CollectionItemMatcher(itemMatcher);
    }
}
