package ru.yandex.autotests.direct.web.util.matchers;

import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

/**
 * User: alexey-n
 * Date: 10.07.13
 * Time: 10:42
 */
public class IgnoreCase extends TypeSafeMatcher<String> {

    protected final Matcher<String> stringMatcher;

    public IgnoreCase(Matcher<String> stringMatcher) {
        this.stringMatcher = stringMatcher;
    }

    @Override
    public boolean matchesSafely(String item) {
        return stringMatcher.matches(item.toLowerCase());
    }

    public void describeTo(Description description) {
        description.appendDescriptionOf(stringMatcher);
    }

    @Override
    protected void describeMismatchSafely(String item, Description mismatchDescription) {
        mismatchDescription.appendText("text was").appendValue(item.toLowerCase());
    }

    @Factory
    public static Matcher<String> ignoreCase(final Matcher<String> stringMatcher) {
        return new IgnoreCase(stringMatcher);
    }
}
