package ru.yandex.autotests.direct.web.util.matchers;

import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

import static org.hamcrest.Matchers.containsString;
import static org.hamcrest.Matchers.equalTo;

public class IgnoreWhiteSpaceDiffStringMatcherWrapper extends TypeSafeMatcher<String> {
    private Matcher<String> matcher;

    private IgnoreWhiteSpaceDiffStringMatcherWrapper(Matcher matcher) {
        this.matcher = matcher;
    }

    @Override
    protected boolean matchesSafely(String string) {
        string = getStringWithSimpleSpaces(string);
        return matcher.matches(string);
    }


    @Override
    public void describeTo(Description description) {
        matcher.describeTo(description);
    }

    /**
     * @param bean
     * @return matcher, for which whitespaces with code 0xa0 and 0x20 are the same chars
     */
    public static Matcher<String> equalToIgnoringWhiteSpaceDiff(String bean) {
        return new IgnoreWhiteSpaceDiffStringMatcherWrapper(equalTo(getStringWithSimpleSpaces(bean)));
    }

    /**
     * @param bean
     * @return containsString matcher, for which whitespaces with code 0xa0 and 0x20 are the same chars at contains String
     */
    public static Matcher<String> containsIgnoringWhiteSpaceDiff(String bean) {
        return new IgnoreWhiteSpaceDiffStringMatcherWrapper(containsString(getStringWithSimpleSpaces(bean)));
    }

    private static String getStringWithSimpleSpaces(String string) {
        return string != null ? string.replaceAll("\u00a0", " ") : string;
    }
}
