package ru.yandex.autotests.direct.web.util.matchers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

/**
 * Матчер вхождения строки в каждый элемент списка
 *
 * @author Vitaliy_Dobriyan
 */
public class IsAnyListItemContainsMatcher extends TypeSafeMatcher<Collection<?>> {

    private static List<String> expectedItems;
    private boolean isAnyItemContains;
    private List<String> incorrectItems = new ArrayList<>();

    public IsAnyListItemContainsMatcher(List<String> expectedItems) {
        IsAnyListItemContainsMatcher.expectedItems = expectedItems;
    }

    @Override
    public void describeTo(Description description) {
        describeMismatchSafely(incorrectItems, description.appendText("Ожидается вхождение строк в элементы списка, " +
                "но имеются некорректные элементы:"));
    }

    @Override
    protected boolean matchesSafely(Collection<?> actualList) {
        String itemString;
        for (String expectedItem : expectedItems) {
            isAnyItemContains = false;
            for (Object item : actualList) {
                itemString = ((String) item);
                if (itemString.contains(expectedItem)) {
                    isAnyItemContains = true;
                }
            }
            if (!isAnyItemContains) {
                incorrectItems.add(expectedItem);
            }
        }
        return (incorrectItems.size() == 0);
    }

    @Factory
    public static Matcher<Collection<?>> anyItemContains(List<String> expectedItems) {
        return new IsAnyListItemContainsMatcher(expectedItems);
    }

}
