package ru.yandex.autotests.direct.web.util.matchers;

import java.lang.reflect.Method;

import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Factory;

/**
 * @author Roman Kuhta (kuhtich@yandex-team.ru)
 */
public class IsDisplayedMatcher extends BaseMatcher {
    @Override
    public boolean matches(Object o) {
        return isDisplayed(o);
    }

    @Override
    public void describeTo(Description description) {
        description.appendText("element is displayed on page");
    }

    private <T> boolean isDisplayed(T element) {
        try {
            Method method = element.getClass().getMethod("isDisplayed");
            return (Boolean) method.invoke(element);
        } catch (Exception e) {
            return false;
        }
    }

    @Factory
    public static IsDisplayedMatcher isDisplayed() {
        return new IsDisplayedMatcher();
    }
}
