package ru.yandex.autotests.direct.web.util.matchers;

import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.TypeSafeMatcher;
import org.openqa.selenium.WebElement;

/**
 * Матчер активности элемента по классу
 *
 * @author Vitaliy_Dobriyan
 */
public class IsElementActiveMatcher extends TypeSafeMatcher<WebElement> {

    private final String ATTR_CLASS = "class";
    private final String ACTIVE_CLASS_VALUE = "tab_current_yes";

    public IsElementActiveMatcher() {
    }

    public void describeTo(Description description) {
        description.appendText("Элемент активен");
    }

    @Factory
    public static IsElementActiveMatcher isActive() {
        return new IsElementActiveMatcher();
    }

    @Override
    protected boolean matchesSafely(WebElement arg0) {
        return arg0.getAttribute(ATTR_CLASS).contains(ACTIVE_CLASS_VALUE);
    }
}
