package ru.yandex.autotests.direct.web.util.matchers;

import java.util.List;

import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import org.openqa.selenium.WebElement;

import ru.yandex.autotests.direct.cmd.data.sort.SortOrder;
import ru.yandex.autotests.direct.web.data.showcampaigns.SortParameters;
import ru.yandex.autotests.direct.web.pages.campaigns.blocks.CampaignRow;

/**
 * Проверка сортировки списка по параметру сортировки и направлению
 *
 * @author Vitaliy_Dobriyan
 */
public class IsListSortedByParameterMatcher extends TypeSafeMatcher<List<CampaignRow>> {

    private SortOrder sortOrder;
    private SortParameters sortParameter;
    private static final String ATTR_CLASS = "class";
    private static final String HIGHLIGHTED_CLASS_VALUE = "b-campaigns-list-item__setting_highlighted_yes";
    private int suitedItemsCount = 0;

    public IsListSortedByParameterMatcher(SortParameters sortParameter, SortOrder sortOrder) {
        this.sortOrder = sortOrder;
        this.sortParameter = sortParameter;
    }

    @Override
    public void describeTo(Description description) {
        description.appendText("Список имеет сортировку: " + sortParameter + ", " + sortOrder);
    }

    @Override
    protected boolean matchesSafely(List<CampaignRow> campaignRows) {
        boolean isOrderCorrect = true;
        int lastItemIndex = campaignRows.size() - 1;

        for (CampaignRow campaignRow : campaignRows) {
            if (isCampaignSuits(campaignRow)) {
                suitedItemsCount++;
            }
        }

        if (sortOrder == SortOrder.DESCENDING) {
            for (int i = lastItemIndex; i > lastItemIndex - suitedItemsCount; i--) {
                isOrderCorrect = isOrderCorrect && isCampaignSuits(campaignRows.get(i));
            }
        } else {
            for (int i = 0; i < suitedItemsCount; i++) {
                isOrderCorrect = isOrderCorrect && isCampaignSuits(campaignRows.get(i));
            }
        }
        return isOrderCorrect;
    }

    @Factory
    public static Matcher<List<CampaignRow>> isSortedByParameter(SortParameters sortParameter, SortOrder sortOrder) {
        return new IsListSortedByParameterMatcher(sortParameter, sortOrder);
    }


    private boolean isCampaignSuits(CampaignRow campaignRow) {
        boolean isSuits = false;
        for (WebElement parameter : campaignRow.getParametersValue().getValuesLiList()) {
            isSuits = parameter.getAttribute(ATTR_CLASS).contains(HIGHLIGHTED_CLASS_VALUE)
                    && parameter.getText().contains(sortParameter.getSortParameterText().toString());
            if (isSuits) {
                return isSuits;
            }
        }
        return isSuits;
    }
}
