package ru.yandex.autotests.direct.web.util.matchers;

import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

import ru.yandex.qatools.htmlelements.element.TypifiedElement;

/**
 * @author Roman Kuhta (kuhtich@yandex-team.ru)
 */
public class IsTypifiedElementEnabledMatcher extends TypeSafeMatcher<TypifiedElement> {
    @Override
    protected boolean matchesSafely(TypifiedElement element) {
        return element.isEnabled();
    }

    @Override
    public void describeTo(Description description) {
        description.appendText("element is enabled");
    }

    @Override
    public void describeMismatchSafely(TypifiedElement element, Description mismatchDescription) {
        mismatchDescription.appendText("element ").appendValue(element).appendText(" is not enabled");
    }

    /**
     * Creates matcher that checks if element is currently enabled.
     */
    @Factory
    public static Matcher<TypifiedElement> isEnabled() {
        return new IsTypifiedElementEnabledMatcher();
    }
}
