package ru.yandex.autotests.direct.web.util.matchers;

import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.TypeSafeMatcher;

/**
 * User: alexey-n
 * Date: 30.08.13
 * Time: 11:41
 */
public class RegExpMatcher extends TypeSafeMatcher<String> {

    private String regExp;
    private String description;

    public RegExpMatcher(String regExp, String description) {
        this.description = description;
        this.regExp = regExp;
    }

    @Override
    protected boolean matchesSafely(String item) {
        return item.matches(regExp);
    }

    @Override
    protected void describeMismatchSafely(String item, Description mismatchDescription) {
        mismatchDescription.appendValue(item);
    }

    @Override
    public void describeTo(Description description) {
        description.appendText("String meets regular expression: '" + regExp + "'");
        if (this.description != null) {
            description.appendText(" info: '" + this.description + "'");
        }
    }

    @Factory
    public static RegExpMatcher meetRegExp(String regExp, String description) {
        return new RegExpMatcher(regExp, description);
    }

    @Factory
    public static RegExpMatcher meetRegExp(String regExp) {
        return new RegExpMatcher(regExp, null);
    }
}
