package ru.yandex.autotests.direct.web.util.matchers.webdriver;

import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import org.openqa.selenium.WebDriver;

public class HasTitle extends TypeSafeMatcher<WebDriver> {
    private Matcher<String> matcher;

    private HasTitle(Matcher<String> matcher) {
        this.matcher = matcher;
    }

    @Override
    protected boolean matchesSafely(WebDriver item) {
        //избавляемся от no-break space
        return matcher.matches(item.getTitle().replace("\u00a0", ""));
    }

    public void describeTo(Description description) {
        description
                .appendText("page has title ")
                .appendDescriptionOf(matcher);
    }

    @Override
    protected void describeMismatchSafely(WebDriver item, Description mismatchDescription) {
        mismatchDescription
                .appendText("title was [")
                .appendText(item.getTitle())
                .appendText("]");
    }

    @Factory
    public static Matcher<WebDriver> hasTitle(Matcher<String> matcher) {
        return new HasTitle(matcher);
    }
}
