package ru.yandex.autotests.direct.web.util.matchers.webdriver;

import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import org.openqa.selenium.WebDriver;

public class HasURL extends TypeSafeMatcher<WebDriver> {
    private Matcher<String> matcher;

    private HasURL(Matcher<String> matcher) {
        this.matcher = matcher;
    }

    @Override
    protected boolean matchesSafely(WebDriver item) {
        return matcher.matches(item.getCurrentUrl());
    }

    public void describeTo(Description description) {
        description
                .appendText("page has url ")
                .appendDescriptionOf(matcher);
    }

    @Override
    protected void describeMismatchSafely(WebDriver item, Description mismatchDescription) {
        mismatchDescription
                .appendText("url was [")
                .appendText(item.getCurrentUrl())
                .appendText("]");
    }

    @Factory
    public static Matcher<WebDriver> hasURL(Matcher<String> matcher) {
        return new HasURL(matcher);
    }
}
