package ru.yandex.autotests.direct.web.util.matchers.webdriver;

import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import org.openqa.selenium.WebDriver;

import ru.yandex.autotests.direct.web.util.WebDriverUtils;

public class OneOfPages extends TypeSafeMatcher<WebDriver> {
    private Matcher<WebDriver> matcher;

    private OneOfPages(Matcher<WebDriver> matcher) {
        this.matcher = matcher;
    }

    @Override
    protected boolean matchesSafely(WebDriver driver) {
        String currentHandle = driver.getWindowHandle();
        boolean result = WebDriverUtils.activatePage(driver, matcher);
        driver.switchTo().window(currentHandle);
        return result;
    }

    public void describeTo(Description description) {
        description
                .appendText("Driver with ")
                .appendDescriptionOf(matcher);
    }

    @Override
    protected void describeMismatchSafely(WebDriver item, Description mismatchDescription) {
        mismatchDescription
                .appendText("page not found");
    }

    @Factory
    public static Matcher<WebDriver> hasOneOfPages(Matcher<WebDriver> matcher) {
        return new OneOfPages(matcher);
    }
}
