package ru.yandex.autotests.direct.web.webelements;

import java.util.Calendar;
import java.util.Date;

import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;

import ru.yandex.autotests.direct.web.util.DateHelper;

import static ru.yandex.autotests.direct.web.util.helpers.DateParser.parseDate;

/**
 * @author Roman Kuhta (kuhtich@yandex-team.ru)
 */
public class CalendarInput extends AbstractCalendarInput {
    public CalendarInput(WebElement wrappedElement) {
        super(wrappedElement);
    }

    @Override
    protected CalendarPopupBlock getPopup() {
        return new CalendarPopupBlock(getWrappedElement().findElement(By.xpath("//div[@id = 'dp-popup']")));
    }

    @Override
    public WebElement getOpenPopupButton() {
        return getWrappedElement().findElement(By.xpath("./descendant::input[@class='b-form-button__input'][1]"));
    }

    @Override
    public Date getDate() {
        return DateHelper.parseDate(getWrappedElement().findElement(
                By.xpath(".//input[contains(@class, 'b-date-input__hidden')]")).getAttribute("value"));
    }

    @Override
    public void fillDate(Date date) {
        getOpenPopupButton().click();
        if (date == null) {
            getPopup().getClearButton().click();
        } else {
            getPopup().fillDate(date);
        }
    }

    public void clear() {
        getOpenPopupButton().click();
        getPopup().getClearButton().click();
    }

    protected class CalendarPopupBlock extends AbstractCalendarInput.CalendarPopupBlock {
        protected CalendarPopupBlock(WebElement wrappedElement) {
            super(wrappedElement);
        }

        @Override
        protected WebElement getTodayButton() {
            return getWrappedElement().findElement(By.xpath(".//div[@class = 'dp-nav-today']/a"));
        }

        protected WebElement getClearButton() {
            return getWrappedElement().findElement(By.xpath(".//div[@class = 'dp-nav-clear']/a"));
        }

        @Override
        protected Year getYear() {
            return new Year(getWrappedElement().findElement(By.xpath(".//div[@class = 'dp-nav-year']")));
        }

        @Override
        protected Month getMonth() {
            return new Month(getWrappedElement().findElement(By.xpath(".//div[@class = 'dp-nav-month']")));
        }

        @Override
        protected WebElement getDayOfMonth(int day) {
            return getWrappedElement().findElement(By.xpath(".//td[contains(@class, 'current-month') and text() = '"
                    + String.valueOf(day) + "']"));
        }
    }

    protected class Year extends AbstractCalendarInput.Year {
        protected Year(WebElement wrappedElement) {
            super(wrappedElement);
        }

        @Override
        protected WebElement getSelectPrev() {
            return getWrappedElement().findElement(By.xpath(".//a[@class = 'dp-nav-prev-year']"));
        }

        @Override
        protected WebElement getSelectNext() {
            return getWrappedElement().findElement(By.xpath(".//a[@class = 'dp-nav-next-year']"));
        }

        @Override
        protected int getValue() {
            return Integer.parseInt(getWrappedElement().findElement(By.xpath(".//h2")).getText());
        }
    }

    protected class Month extends AbstractCalendarInput.Month {
        protected Month(WebElement wrappedElement) {
            super(wrappedElement);
        }

        @Override
        protected WebElement getSelectPrev() {
            return getWrappedElement().findElement(By.xpath(".//a[@class = 'dp-nav-prev-month']"));
        }

        @Override
        protected WebElement getSelectNext() {
            return getWrappedElement().findElement(By.xpath(".//a[@class = 'dp-nav-next-month']"));
        }

        @Override
        protected int getValue() {
            return parseDate(getWrappedElement().findElement(By.xpath(".//h2")).getText(), "MMMM").get(Calendar.MONTH);
        }
    }
}
